package gov.va.vinci.dart.biz;

import java.util.List;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestEvent extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {

		List<DartRequest> drList = DartRequest.listAll();
		Assert.assertNotNull(drList);
		Assert.assertTrue(drList.size() > 0);
		
		DartRequest request = drList.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);

		Assert.assertNotNull(request.getActivity());
		Assert.assertTrue(request.getActivity().getId() > 0);

		Event event = Event.create(EventType.INITIATE_REQUEST, request, "DNS");
		Assert.assertNotNull(event);
		Assert.assertTrue(event.getId() > 0);

		Group group = Group.findById(1);
		Assert.assertNotNull(group);
		Assert.assertTrue(group.getId() > 0);

		Event event2 = Event.create("Event Name", "Event Description", EventType.INITIATE_REQUEST, group, true, request,  "DNS");
		Assert.assertNotNull(event2);
		Assert.assertTrue(event2.getId() > 0);

		
		List<Event> eList = Event.listByEventTypeAndRequestId(EventType.INITIATE_REQUEST.getId(), request.getId());
		Assert.assertNotNull(eList);
		Assert.assertTrue(eList.size() > 0);
		Assert.assertTrue(eList.contains(event));

		
		eList = Event.listByRequestIdAndGroupId(request.getId(), group.getId());
		Assert.assertNotNull(eList);
		Assert.assertTrue(eList.size() > 0);
		Assert.assertFalse(eList.contains(event));
		Assert.assertTrue(eList.contains(event2));

		eList = Event.listByActivityIdAndGroupOrder(request.getActivity().getId(), group.getId(), false);
		Assert.assertNotNull(eList);
		Assert.assertFalse(eList.contains(event));
		Assert.assertFalse(eList.contains(event2));

		eList = Event.listByActivityIdAndGroupOrder(request.getActivity().getId(), group.getId(), true);
		Assert.assertNotNull(eList);
		Assert.assertTrue(eList.size() > 0);
		Assert.assertFalse(eList.contains(event));
		Assert.assertTrue(eList.contains(event2));

		eList = Event.listByRequestIdAndGroupOrder(request.getId(), group.getId(), false);
		Assert.assertNotNull(eList);
		Assert.assertFalse(eList.size() > 0);

		eList = DartObjectFactory.getInstance().getEventDAO().listByRequestIdAndGroupOrder(request.getId(), group.getId(), true);
		Assert.assertNotNull(eList);
		Assert.assertTrue(eList.size() > 0);
		Assert.assertFalse(eList.contains(event));
		Assert.assertTrue(eList.contains(event2));

		eList = Event.listByEventTypeAndActivityIdAndGroupId(EventType.INITIATE_REQUEST.getId(), request.getActivity().getId(), group.getId());
		Assert.assertNotNull(eList);
		Assert.assertTrue(eList.size() > 0);
		Assert.assertFalse(eList.contains(event));
		Assert.assertTrue(eList.contains(event2));
		

		eList = Event.listByEventTypeAndActivityIdAndGroupOrder(EventType.INITIATE_REQUEST.getId(), request.getActivity().getId(), group.getId(), false);
		Assert.assertNotNull(eList);
		Assert.assertFalse(eList.size() > 0);

		eList = Event.listByEventTypeAndActivityIdAndGroupOrder(EventType.INITIATE_REQUEST.getId(), request.getActivity().getId(), group.getId(), true);
		Assert.assertNotNull(eList);
		Assert.assertTrue(eList.size() > 0);
		Assert.assertFalse(eList.contains(event));
		Assert.assertTrue(eList.contains(event2));

		eList = Event.listByEventTypeAndRequestIdAndGroupOrder(EventType.INITIATE_REQUEST.getId(), request.getId(), group.getId(), false);
		Assert.assertNotNull(eList);
		Assert.assertFalse(eList.size() > 0);

		eList = Event.listByEventTypeAndRequestIdAndGroupOrder(EventType.INITIATE_REQUEST.getId(), request.getId(), group.getId(), true);
		Assert.assertNotNull(eList);
		Assert.assertTrue(eList.size() > 0);
		Assert.assertFalse(eList.contains(event));
		Assert.assertTrue(eList.contains(event2));

		eList = Event.listByGroup(group.getId());
		Assert.assertNotNull(eList);
		Assert.assertTrue(eList.size() > 0);
		Assert.assertFalse(eList.contains(event));
		Assert.assertTrue(eList.contains(event2));

		List<EventSummary> esList = Event.listSummaryByRequestId(request.getId());
		Assert.assertNotNull(esList);
		Assert.assertTrue(esList.size() > 0);

		esList = Event.listSummaryByActivityId(request.getActivity().getId());
		Assert.assertNotNull(esList);
		Assert.assertTrue(esList.size() > 0);
	}
}
